//===================================================================
// FlameLauncher.FlameLauncher_Fire
// That's the codebase.
//===================================================================
class FTFire expands Projectile;


var(Flame) texture SpriteAnim[10];
var int i;
var burn FinalBurn;


simulated function Timer()
{
	Texture = SpriteAnim[i];
	i++;
	if (i>=10) i=10;
}

function SetUp()
{
	Velocity = Vector(Rotation) * speed;
	MakeNoise (1.0);
}

simulated function PostBeginPlay()
{
	SetUp();
	if ( Level.NetMode != NM_DedicatedServer )
	{
		Texture = SpriteAnim[0];
		i=1;
		SetTimer(0.0525,True);
	}
	Super.PostBeginPlay();
}


auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (Other != instigator)
		{
			if ( Role == ROLE_Authority )
			Other.TakeDamage(Damage, instigator, HitLocation, 15000.0 * Normal(velocity), 'burned');
			
			if ( FinalBurn == None )
			{
                		FinalBurn=Spawn(class'Burn',Instigator,,Other.Location,Other.Rotation);

   				FinalBurn.LifeTime=1.0;

				// Attaches the fire to the target

   				FinalBurn.SetBase(Other);			
			}
			else
			{
				// If the target already on fire, make the fire last longer.
                   		FinalBurn.LifeTime+=5.0;
			}

			Destroy();
			//Explode(HitLocation, Vect(0,0,0));
		}
	}

	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		HurtRadius(Damage, 50, 'Burned', 0, Location);
		Destroy();
	}

	simulated function HitWall (vector HitNormal, actor Wall)
	{
		local vector NewDir;

		NewDir = Velocity;
		NewDir.Z = 250;

		Spawn(ExplosionDecal,,,Location, rotator(HitNormal));
	}

	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local UT_ShortSmokeGen ut_SSG;

		if (!NewZone.bWaterZone) Return;
		if ( Level.NetMode != NM_DedicatedServer )
		{
			ut_SSG = Spawn(class'UT_ShortSmokeGen');
			ut_SSG.TotalNumPuffs = 5;
		}
		Destroy();
	}

	function BeginState()
	{
		if ( Region.Zone.bWaterZone && FRand() > 0.30 )
		{
			Destroy();
		}
	}

Begin:
Sleep(0.5);
Explode(Location, Vect(0,0,0));
}

defaultproperties
{
    SpriteAnim(0)=Texture'UnrealShare.FlameEffect.e_a01'
    SpriteAnim(1)=Texture'UnrealShare.FlameEffect.e_a02'
    SpriteAnim(2)=Texture'UnrealShare.FlameEffect.e_a03'
    SpriteAnim(3)=Texture'UnrealShare.FlameEffect.e_a04'
    SpriteAnim(4)=Texture'UnrealShare.FlameEffect.e_a05'
    SpriteAnim(5)=Texture'UnrealShare.FlameEffect.e_a06'
    SpriteAnim(6)=Texture'UnrealShare.FlameEffect.e_a07'
    SpriteAnim(7)=Texture'UnrealShare.FlameEffect.e_a08'
    SpriteAnim(8)=Texture'UnrealShare.FlameEffect.e_a09'
    SpriteAnim(9)=Texture'UnrealShare.FlameEffect.e_a10'
    speed=3580.00
    MaxSpeed=3500.00
    Damage=10.00
    MyDamageType=Burned
    ExplosionDecal=Class'Botpack.EnergyImpact'
    DrawType=7
    Style=3
    AmbientGlow=128
    LightType=1
    LightEffect=13
    LightBrightness=240
    LightHue=12
    LightSaturation=72
    LightRadius=5
}
